---
title: Announcing Workers VPC Services (Beta) · Changelog
description: Access private resources in your VPC from Cloudflare Workers
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-09-25-workers-vpc/
  md: https://developers.cloudflare.com/changelog/2025-09-25-workers-vpc/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Announcing Workers VPC Services (Beta)

Nov 05, 2025

[Workers VPC](https://developers.cloudflare.com/workers-vpc/)

**Workers VPC Services** is now available, enabling your Workers to securely access resources in your private networks, without having to expose them on the public Internet.

#### What's new

* **VPC Services**: Create secure connections to internal APIs, databases, and services using familiar Worker binding syntax
* **Multi-cloud Support**: Connect to resources in private networks in any external cloud (AWS, Azure, GCP, etc.) or on-premise using Cloudflare Tunnels

```js
export default {
  async fetch(request, env, ctx) {
    // Perform application logic in Workers here


    // Sample call to an internal API running on ECS in AWS using the binding
    const response = await env.AWS_VPC_ECS_API.fetch("https://internal-host.example.com");


    // Additional application logic in Workers
    return new Response();
  },
};
```

#### Getting started

Set up a Cloudflare Tunnel, create a VPC Service, add service bindings to your Worker, and access private resources securely. [Refer to the documentation](https://developers.cloudflare.com/workers-vpc/) to get started.
