---
title: Return information about the incoming request · Cloudflare Rules docs
description: Respond with information about the incoming request provided by
  Cloudflare’s global network.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Logging,Response modification
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/return-incoming-request-properties/
  md: https://developers.cloudflare.com/rules/snippets/examples/return-incoming-request-properties/index.md
---

```js
export default {
  async fetch(request) {
    // For any request, respond with JSON object containing all incoming request properties provided by Cloudflare network
    return Response.json(request.cf, {
      // Add new header to identify request was served by Snippets
      headers: {
        "x-snippets-hello": "Hello from Cloudflare Snippets",
      },
    });
  },
};
```
