---
title: http.request.jwt.claims.iss · Cloudflare Ruleset Engine docs
description: The `iss` (issuer) claim identifies the principal that issued the JWT.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.jwt.claims.iss/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.jwt.claims.iss/index.md
---

# http.request.jwt.claims.iss

`http.request.jwt.claims.iss` Map\<Array\<String>>

The `iss` (issuer) claim identifies the principal that issued the JWT.

For details, refer to the [Registered Claim Names](https://datatracker.ietf.org/doc/html/rfc7519#section-4.1) in RFC 7519.

Requires a Cloudflare Enterprise plan with a paid add-on.

For more information on validating JSON Web Tokens, refer to [JSON Web Tokens Validation](https://developers.cloudflare.com/api-shield/security/jwt-validation/) in the API Shield documentation.

Categories:

* Request
* JWT validation
