---
title: Token validation · Cloudflare Turnstile docs
description: After a visitor successfully completes a Turnstile challenge, a
  token is generated and validated via the Siteverify API. Token validation data
  provides crucial insights into your security posture.
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/turnstile/turnstile-analytics/token-validation/
  md: https://developers.cloudflare.com/turnstile/turnstile-analytics/token-validation/index.md
---

After a visitor successfully completes a Turnstile challenge, a token is generated and validated via the Siteverify API. Token validation data provides crucial insights into your security posture.

For example, the token validation values in your analytics may look like this:

![Token validation example values](https://developers.cloudflare.com/_astro/token-validation.DRmcNOiF_1E5hpj.webp)

## Metrics

* **Siteverify requests**: The total number of requests made to the Siteverify API in the given timeframe.
* **Valid tokens**: The number of Siteverify requests with `success:true` responses.
* **Invalid tokens**: The number of Siteverify requests with `success:false` responses.

### Call Siteverify

It is important to [call the Siteverify API](https://developers.cloudflare.com/turnstile/get-started/server-side-validation/). Without calling Siteverify API to validate the tokens, your website or application is not protected. Skipping token validation means you cannot confirm the visitor's legitimacy.

* Tokens can only be redeemed once. Even valid tokens will return `success:false` if they are reused, preventing token theft and replay attacks.
* Tokens expire after five minutes. Validation must occur within this window to be effective.
* Tokens can be invalid. Bots might complete challenges, but Cloudflare can detect bot-like signals and mark the token as invalid.
